function SettingsCtrl($scope, SettingsManager)
{
    $scope.marketSegments = SettingsManager.loadData();
    $scope.onlyElectronics = true;

    if($scope.onlyElectronics)
    {
        $scope.marketSegmentsAfterFilter = [];

        angular.forEach($scope.marketSegments, function(segment) {
            if(segment.symbol === 'AUTO')
                $scope.marketSegmentsAfterFilter.push(segment);
        });

        $scope.marketSegments = $scope.marketSegmentsAfterFilter;
    }

    $scope.selectSegment = function(segment){
        SettingsManager.selectSegment(segment);
    }
}

SettingsCtrl.$inject = ['$scope', 'SettingsManager'];